/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomRegisters;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.NPCSpawning;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.Server;
import noppes.npcs.api.event.WorldEvent;
import noppes.npcs.api.wrapper.BlockWrapper;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumSync;
import noppes.npcs.containers.ContainerNPCBank;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.BorderController;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.MassBlockController;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerGameData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataScenes;
import noppes.npcs.items.ItemBuilder;
import noppes.npcs.roles.RoleFollower;
import noppes.npcs.util.BuilderData;
import noppes.npcs.util.Util;

public class ServerTickHandler {
    private static final Map<EntityPlayerMP, GameType> visibleData = new HashMap<EntityPlayerMP, GameType>();
    public static int ticks = 0;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.START) {
            return;
        }
        CustomNpcs.debugData.start("Player");
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        PlayerData data = PlayerData.get((EntityPlayer)player);
        long resTime = player.func_70005_c_().codePointAt(0);
        if (!visibleData.containsKey(player) || visibleData.get(player) != player.field_71134_c.func_73081_b() || player.field_70170_p.func_82737_E() % 100L == resTime % 100L || data.prevHeldItem != player.func_184614_ca() && (data.prevHeldItem.func_77973_b() == CustomRegisters.wand || player.func_184614_ca().func_77973_b() == CustomRegisters.wand)) {
            visibleData.put(player, player.field_71134_c.func_73081_b());
            CustomNpcs.visibilityController.onUpdate(player);
        }
        if (player.field_70170_p.func_82737_E() % 20L == resTime % 20L) {
            data.hud.updateHud(player);
            data.minimap.update(player);
            boolean isOP = false;
            if (player.func_184102_h() != null) {
                if (player.func_184102_h().func_71264_H()) {
                    isOP = true;
                } else {
                    UserListOpsEntry util = (UserListOpsEntry)player.func_184102_h().func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH());
                    if (util != null) {
                        boolean bl = isOP = util.func_152644_a() >= 4;
                    }
                }
            }
            if (data.game.op != isOP) {
                data.game.op = isOP;
                data.game.updateClient = true;
            }
            if (player.field_71070_bA instanceof ContainerNPCBank) {
                int count;
                Bank.CeilSettings cs;
                ContainerNPCBank c = (ContainerNPCBank)player.field_71070_bA;
                boolean work = true;
                int ceil = c.bank.ceilSettings.size();
                if (c.items.func_70302_i_() == 0) {
                    if (c.ceil > 0) {
                        for (int i = c.ceil - 1; i >= 0 && c.data.cells.containsKey(i); --i) {
                            NpcMiscInventory inv = c.data.cells.get(i);
                            cs = c.bank.ceilSettings.get(i);
                            boolean bl = work = inv.func_70302_i_() > 0 && cs.upgradeStack.func_190926_b() || cs.maxCells == inv.func_70302_i_();
                            if (work) continue;
                            ceil = i;
                            break;
                        }
                    }
                    if (work) {
                        cs = c.bank.ceilSettings.get(c.ceil);
                        if (!cs.openStack.func_190926_b() && (count = Util.instance.inventoryItemCount((EntityPlayer)player, cs.openStack, null, false, false)) < cs.openStack.func_190916_E()) {
                            ceil = -1;
                        }
                    }
                } else {
                    cs = c.bank.ceilSettings.get(c.ceil);
                    boolean bl = work = c.items.func_70302_i_() > 0 && c.items.func_70302_i_() < cs.maxCells;
                    if (work && !cs.upgradeStack.func_190926_b() && (count = Util.instance.inventoryItemCount((EntityPlayer)player, cs.upgradeStack, null, false, false)) < cs.upgradeStack.func_190916_E()) {
                        ceil = -1;
                    }
                }
                if (c.dataCeil != ceil) {
                    c.dataCeil = ceil;
                    Server.sendData(player, EnumPacketClient.BANK_CEIL_OPEN, ceil);
                }
            }
            ArrayList<PlayerGameData.FollowerSet> del = new ArrayList<PlayerGameData.FollowerSet>();
            for (PlayerGameData.FollowerSet fs : data.game.getFollowers()) {
                Entity e;
                EntityNPCInterface npc = null;
                if (fs.npc != null) {
                    npc = fs.npc;
                }
                if (npc == null && (e = Util.instance.getEntityByUUID(fs.id, player.field_70170_p)) instanceof EntityNPCInterface) {
                    npc = (EntityNPCInterface)e;
                }
                if (npc == null || npc.field_70128_L || !(npc.advanced.roleInterface instanceof RoleFollower)) {
                    del.add(fs);
                } else {
                    EntityPlayer owner = ((RoleFollower)npc.advanced.roleInterface).getOwner();
                    if (owner == null || !owner.equals((Object)player)) {
                        del.add(fs);
                    } else if (fs.npc == null) {
                        fs.npc = npc;
                    }
                }
                if (npc == null || !(npc.advanced.roleInterface instanceof RoleFollower)) continue;
                if (player.field_70170_p.field_73011_w.getDimension() != npc.field_70170_p.field_73011_w.getDimension()) {
                    try {
                        Entity entity = Util.instance.teleportEntity(player.field_70170_p.func_73046_m(), (Entity)npc, player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v);
                        if (!(entity instanceof EntityNPCInterface)) continue;
                        fs.dimId = entity.field_70170_p.field_73011_w.getDimension();
                        fs.id = entity.func_110124_au();
                        ((EntityNPCInterface)entity).func_70661_as().func_75497_a((Entity)player, ((EntityNPCInterface)entity).ais.canSprint ? 1.3 : 1.0);
                    }
                    catch (CommandException e2) {
                        LogWriter.error("Error when trying to move an entity:", e2);
                    }
                    continue;
                }
                if (!(npc.advanced.roleInterface instanceof RoleFollower) || !(player.func_70032_d((Entity)npc) > (float)((RoleFollower)npc.advanced.roleInterface).getRange())) continue;
                npc.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            }
            for (PlayerGameData.FollowerSet fs : del) {
                data.game.removeFollower(fs);
            }
        }
        if (player.field_70170_p.func_82737_E() % 200L == resTime % 200L) {
            if (data.hud.currentGUI.equalsIgnoreCase("guichat") || data.hud.currentGUI.equalsIgnoreCase("guiingame")) {
                for (QuestData questData : data.questData.activeQuests.values()) {
                    data.questData.checkQuestCompletion((EntityPlayer)player, questData);
                }
            }
            if (!data.mailData.playerMails.isEmpty()) {
                boolean needSend = false;
                long time = System.currentTimeMillis();
                long timeToRemove = -1L;
                if (CustomNpcs.MailTimeWhenLettersWillBeDeleted > 0) {
                    timeToRemove = (long)CustomNpcs.MailTimeWhenLettersWillBeDeleted * 86400000L;
                }
                ArrayList<PlayerMail> del = new ArrayList<PlayerMail>();
                for (PlayerMail mail : data.mailData.playerMails) {
                    if (player.field_71075_bZ.field_75098_d && mail.timeWillCome > 0L) {
                        mail.timeWillCome = 0L;
                        needSend = true;
                    }
                    long timeWhenReceived = time - mail.timeWhenReceived - mail.timeWillCome;
                    if (timeToRemove > 0L && timeWhenReceived > timeToRemove) {
                        del.add(mail);
                        needSend = true;
                    }
                    if (mail.beenRead || timeWhenReceived < 0L) continue;
                    needSend = true;
                }
                for (PlayerMail mail : del) {
                    data.mailData.playerMails.remove(mail);
                }
                if (needSend) {
                    Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.MailData, data.mailData.saveNBTData(new NBTTagCompound())});
                }
            }
        }
        if (data.updateClient) {
            Server.sendData(player, EnumPacketClient.SYNC_END, new Object[]{EnumSync.PlayerData, data.getSyncNBT()});
            data.updateClient = false;
        }
        if (data.questData.updateClient) {
            NBTTagCompound compound = new NBTTagCompound();
            data.questData.saveNBTData(compound);
            Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.PlayerQuestData, compound});
            data.questData.updateClient = false;
        }
        if (data.game.updateClient) {
            Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.GameData, data.game.saveNBTData(new NBTTagCompound())});
            data.game.updateClient = false;
        }
        data.bankData.update(player);
        data.prevHeldItem = player.func_184614_ca();
        CustomNpcs.debugData.end("Player");
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        EntityPlayerMP player;
        if (event.side == Side.CLIENT || event.phase == TickEvent.Phase.END) {
            return;
        }
        CustomNpcs.debugData.start(null);
        BorderController.getInstance().update();
        if (++ticks % 20 == 0) {
            SchematicController.Instance.updateBuilding();
            MassBlockController.Update();
            MarcetController.getInstance().update();
            for (DataScenes.SceneState state : DataScenes.StartedScenes.values()) {
                if (state.paused) continue;
                ++state.ticks;
            }
            for (DataScenes.SceneContainer entry : DataScenes.ScenesToRun) {
                entry.update();
            }
            DataScenes.ScenesToRun.clear();
            if (ticks % 6000 == 0) {
                ArrayList<Integer> del = new ArrayList<Integer>();
                for (int id : SyncController.dataBuilder.keySet()) {
                    BuilderData bd = SyncController.dataBuilder.get(id);
                    if (bd.player == null) {
                        del.add(id);
                        continue;
                    }
                    ItemStack stack = null;
                    for (ItemStack s : bd.player.field_71071_by.field_70462_a) {
                        if (!ItemBuilder.isBuilder(s, bd)) continue;
                        stack = s;
                        break;
                    }
                    if (stack != null) continue;
                    del.add(id);
                }
                for (Integer id : del) {
                    SyncController.dataBuilder.remove(id);
                }
            }
        }
        if (ticks % 10 == 0 && CustomNpcs.Server != null && !CustomNpcs.Server.func_184103_al().func_181057_v().isEmpty() && (player = (EntityPlayerMP)CustomNpcs.Server.func_184103_al().func_181057_v().get(0)) != null) {
            EventHooks.onEvent((IScriptHandler)PlayerData.get((EntityPlayer)player).scriptData, "worldtick", (Event)new WorldEvent.ServerTickEvent(event));
        }
        if (ticks % 1200 == 0) {
            BankController.getInstance().update();
        }
        if (ticks % 60 == 0) {
            BlockWrapper.checkClearCache();
        }
        CustomNpcs.debugData.end(null);
    }

    @SubscribeEvent
    public void onServerWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side != Side.SERVER) {
            return;
        }
        CustomNpcs.debugData.start(null);
        if (event.phase == TickEvent.Phase.START) {
            NPCSpawning.findChunksForSpawning((WorldServer)event.world);
        }
        CustomNpcs.debugData.end(null);
    }
}

